/*
 * Decompiled with CFR 0.152.
 */
package teamdraco.unnamedanimalmod.common.entity;

import com.google.common.collect.Sets;
import java.util.EnumSet;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.PanicGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import teamdraco.unnamedanimalmod.common.entity.util.GroundAndSwimmerNavigator;
import teamdraco.unnamedanimalmod.init.UAMItems;
import teamdraco.unnamedanimalmod.init.UAMSounds;

public class TomatoFrogEntity
extends AnimalEntity {
    private Goal swimGoal;
    private boolean wasOnGround;
    private int currentMoveTypeDuration;

    public TomatoFrogEntity(EntityType<? extends TomatoFrogEntity> type, World world) {
        super(type, world);
        this.field_70765_h = new FrogMoveController(this);
        this.field_70138_W = 1.0f;
    }

    protected void func_184651_r() {
        this.swimGoal = new SwimGoal((MobEntity)this);
        this.field_70714_bg.func_75776_a(0, this.swimGoal);
        this.field_70714_bg.func_75776_a(0, (Goal)new PanicGoal((CreatureEntity)this, 1.25));
        this.field_70714_bg.func_75776_a(1, (Goal)new BreedGoal((AnimalEntity)this, 0.8));
        this.field_70714_bg.func_75776_a(2, (Goal)new FrogMovementGoal((CreatureEntity)this));
        this.field_70714_bg.func_75776_a(3, (Goal)new PlayerTemptGoal(this, 1.0, Items.field_151070_bp));
        this.field_70714_bg.func_75776_a(5, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 10.0f));
    }

    public void func_70873_a(int age) {
        boolean wasChild = this.func_70631_g_();
        super.func_70873_a(age);
        boolean isChild = this.func_70631_g_();
        if (!wasChild && isChild) {
            this.field_70714_bg.func_85156_a(this.swimGoal);
            this.field_70138_W = 1.0f;
        } else if (wasChild && !isChild) {
            this.field_70714_bg.func_75776_a(0, this.swimGoal);
            this.field_70138_W = 0.0f;
        }
    }

    protected PathNavigator func_175447_b(World world) {
        return new GroundAndSwimmerNavigator((MobEntity)this, world);
    }

    public boolean func_70648_aU() {
        return this.func_70631_g_();
    }

    protected void updateAir(int air) {
        if (this.func_70631_g_()) {
            if (this.func_70089_S() && !this.func_203005_aq()) {
                this.func_70050_g(air - 1);
                if (this.func_70086_ai() == -20) {
                    this.func_70050_g(0);
                    this.func_70097_a(DamageSource.field_76369_e, 2.0f);
                }
            } else {
                this.func_70050_g(300);
            }
        }
    }

    public void func_70030_z() {
        int lvt_1_1_ = this.func_70086_ai();
        super.func_70030_z();
        this.updateAir(lvt_1_1_);
    }

    public void func_70619_bc() {
        if (!this.func_70631_g_()) {
            if (this.currentMoveTypeDuration > 0) {
                --this.currentMoveTypeDuration;
            }
            if (this.field_70122_E) {
                LivingEntity livingentity;
                if (!this.wasOnGround) {
                    this.checkLandingDelay();
                }
                if (this.currentMoveTypeDuration == 0 && (livingentity = this.func_70638_az()) != null && this.func_70068_e((Entity)livingentity) < 16.0) {
                    this.calculateRotationYaw(livingentity.func_226277_ct_(), livingentity.func_226281_cx_());
                    this.field_70765_h.func_75642_a(livingentity.func_226277_ct_(), livingentity.func_226278_cu_(), livingentity.func_226281_cx_(), this.field_70765_h.func_75638_b());
                    this.wasOnGround = true;
                }
            }
            this.wasOnGround = this.field_70122_E;
        }
    }

    @Nullable
    public AgeableEntity func_241840_a(ServerWorld p_241840_1_, AgeableEntity p_241840_2_) {
        this.func_199701_a_(new ItemStack((IItemProvider)UAMItems.TOMATO_FROG_EGG.get(), this.func_70681_au().nextInt(3) + 1));
        this.func_184185_a(SoundEvents.field_187665_Y, 1.0f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
        ((AnimalEntity)p_241840_2_).func_70875_t();
        return null;
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 8.0).func_233815_a_(Attributes.field_233821_d_, 0.25);
    }

    public ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        ItemStack heldItem = player.func_184586_b(hand);
        if (heldItem.func_77973_b() == Items.field_151054_z && this.func_70089_S() && !this.func_70631_g_()) {
            this.func_184185_a(SoundEvents.field_187620_cL, 1.0f, 1.0f);
            heldItem.func_190918_g(1);
            ItemStack itemstack1 = new ItemStack((IItemProvider)UAMItems.TOMATO_FROG_BOWL.get());
            this.setBucketData(itemstack1);
            if (!this.field_70170_p.field_72995_K) {
                CriteriaTriggers.field_204813_j.func_204817_a((ServerPlayerEntity)player, itemstack1);
            }
            if (heldItem.func_190926_b()) {
                player.func_184611_a(hand, itemstack1);
            } else if (!player.field_71071_by.func_70441_a(itemstack1)) {
                player.func_71019_a(itemstack1, false);
            }
            this.func_70106_y();
            return ActionResultType.SUCCESS;
        }
        return super.func_230254_b_(player, hand);
    }

    private void setBucketData(ItemStack bucket) {
        if (this.func_145818_k_()) {
            bucket.func_200302_a(this.func_200201_e());
        }
    }

    protected SoundEvent func_184639_G() {
        return !this.func_70631_g_() ? (SoundEvent)UAMSounds.FROG_AMBIENT.get() : SoundEvents.field_203815_ax;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return !this.func_70631_g_() ? (SoundEvent)UAMSounds.FROG_HURT.get() : SoundEvents.field_203813_aA;
    }

    protected SoundEvent func_184615_bR() {
        return !this.func_70631_g_() ? (SoundEvent)UAMSounds.FROG_DEATH.get() : SoundEvents.field_203816_ay;
    }

    protected SoundEvent getFlopSound() {
        return SoundEvents.field_203818_az;
    }

    protected float func_70599_aP() {
        return 0.3f;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        return !this.func_180431_b(source) && super.func_70097_a(source, amount);
    }

    public boolean func_70877_b(ItemStack stack) {
        return stack.func_77973_b() == Items.field_151070_bp;
    }

    public boolean func_96092_aw() {
        return false;
    }

    public CreatureAttribute func_70668_bt() {
        return this.func_70631_g_() ? CreatureAttribute.field_203100_e : CreatureAttribute.field_223222_a_;
    }

    private void calculateRotationYaw(double x, double z) {
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)(z - this.func_226281_cx_()), (double)(x - this.func_226277_ct_())) * 57.2957763671875) - 90.0f;
    }

    private void updateMoveTypeDuration() {
        this.currentMoveTypeDuration = this.field_70765_h.func_75638_b() < 2.2 ? 10 : 1;
    }

    private void checkLandingDelay() {
        this.updateMoveTypeDuration();
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.func_70631_g_() && !this.func_70090_H() && this.field_70122_E && this.field_70124_G) {
            this.func_213317_d(this.func_213322_ci().func_72441_c((double)((this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * 0.05f), (double)0.4f, (double)((this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * 0.05f)));
            this.field_70122_E = false;
            this.field_70160_al = true;
            this.func_184185_a(this.getFlopSound(), this.func_70599_aP(), this.func_70647_i());
        }
    }

    public void func_213352_e(Vector3d p_213352_1_) {
        if (this.func_70631_g_() && this.func_70613_aW() && this.func_70090_H()) {
            this.func_213309_a(0.01f, p_213352_1_);
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
            this.func_213317_d(this.func_213322_ci().func_186678_a(0.9));
            if (this.func_70638_az() == null) {
                this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, -0.005, 0.0));
            }
        } else {
            super.func_213352_e(p_213352_1_);
        }
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack((IItemProvider)UAMItems.TOMATO_FROG_SPAWN_EGG.get());
    }

    private static class FrogMovementGoal
    extends WaterAvoidingRandomWalkingGoal {
        public FrogMovementGoal(CreatureEntity creature) {
            super(creature, 1.0);
        }

        protected Vector3d func_190864_f() {
            if (this.field_75457_a.func_70631_g_()) {
                return RandomPositionGenerator.func_75463_a((CreatureEntity)this.field_75457_a, (int)10, (int)7);
            }
            return super.func_190864_f();
        }
    }

    private static class PlayerTemptGoal
    extends Goal {
        private static final EntityPredicate TEMPT_TARGETING = new EntityPredicate().func_221013_a(10.0).func_221011_b().func_221008_a();
        private final TomatoFrogEntity frog;
        private final double speed;
        private PlayerEntity tempter;
        private int cooldown;
        private final Set<Item> temptItems;

        private PlayerTemptGoal(TomatoFrogEntity frog, double speedIn, Item temptItem) {
            this.frog = frog;
            this.speed = speedIn;
            this.temptItems = Sets.newHashSet((Object[])new Item[]{temptItem});
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean func_75250_a() {
            if (this.cooldown > 0) {
                --this.cooldown;
                return false;
            }
            this.tempter = this.frog.field_70170_p.func_217370_a(TEMPT_TARGETING, (LivingEntity)this.frog);
            if (this.tempter == null) {
                return false;
            }
            return this.isTemptedBy(this.tempter.func_184614_ca()) || this.isTemptedBy(this.tempter.func_184592_cb());
        }

        private boolean isTemptedBy(ItemStack p_203131_1_) {
            return this.temptItems.contains(p_203131_1_.func_77973_b());
        }

        public boolean func_75253_b() {
            return this.func_75250_a();
        }

        public void func_75251_c() {
            this.tempter = null;
            this.frog.func_70661_as().func_75499_g();
            this.cooldown = 100;
        }

        public void func_75246_d() {
            this.frog.func_70671_ap().func_75651_a((Entity)this.tempter, (float)(this.frog.func_184649_cE() + 20), (float)this.frog.func_70646_bf());
            if (this.frog.func_70068_e((Entity)this.tempter) < 6.25) {
                this.frog.func_70661_as().func_75499_g();
            } else {
                this.frog.func_70661_as().func_75497_a((Entity)this.tempter, this.speed);
            }
        }
    }

    private static class FrogMoveController
    extends MovementController {
        private final TomatoFrogEntity frog;

        private FrogMoveController(TomatoFrogEntity frog) {
            super((MobEntity)frog);
            this.frog = frog;
        }

        public void func_75641_c() {
            if (this.frog.func_208600_a((ITag)FluidTags.field_206959_a)) {
                this.frog.func_213317_d(this.frog.func_213322_ci().func_72441_c(0.0, 0.005, 0.0));
            }
            if (this.field_188491_h == MovementController.Action.MOVE_TO && !this.frog.func_70661_as().func_75500_f()) {
                double d0 = this.field_75646_b - this.frog.func_226277_ct_();
                double d1 = this.field_75647_c - this.frog.func_226278_cu_();
                double d2 = this.field_75644_d - this.frog.func_226281_cx_();
                double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1 + d2 * d2));
                d1 /= d3;
                float f = (float)(MathHelper.func_181159_b((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
                this.frog.field_70761_aq = this.frog.field_70177_z = this.func_75639_a(this.frog.field_70177_z, f, 90.0f);
                float f1 = (float)(this.field_75645_e * this.frog.func_110148_a(Attributes.field_233821_d_).func_111126_e());
                if (this.frog.func_70631_g_()) {
                    f1 = (float)((double)f1 * 2.8);
                }
                this.frog.func_70659_e(MathHelper.func_219799_g((float)0.125f, (float)this.frog.func_70689_ay(), (float)f1));
                this.frog.func_213317_d(this.frog.func_213322_ci().func_72441_c(0.0, (double)this.frog.func_70689_ay() * d1 * 0.1, 0.0));
            } else {
                this.frog.func_70659_e(0.0f);
            }
        }
    }
}

